﻿var distributionSummary = {
    context: $(".v-distributionSummary"),
    datatable: null,
    initialize: function () {
        this.datatable = $(".h-distribution-respondents-table", distributionSummary.context).a4datatable({                        
            ajaxAction: a4.getSurveyAction("GetAllDistributionRespondents", "Distribute"),
            style: "compact",
            displaySearchBox: canReadPII,
            columns: [
                { "Name": "RespondentId", "Title": resources.Id, "Data": "RespondentId" },
                { "Name": "RespondentEmail", "Title": resources.Email, "Data": "RespondentEmail", "Visible": canReadPII, "HideInSelector": !canReadPII },
                { "Name": "RespondentPhone", "Title": resources.Phone, "Data": "RespondentPhone", "Visible": canReadPII, "HideInSelector": !canReadPII },
                { "Name": "DistributionId", "Title": resources.DistributionId, "Data": "DistributionId" },
                { "Name": "DistributionType", "Title": resources.DistributionType, "Data": "DistributionType" },
                { "Name": "DispositionCode", "Title": resources.Status, "Data": "DispositionCode" },
                { "Name": "AccessDate", "Title": resources.AccessDate, "Data": "AccessDate" },
            ],
            quickFilter: {
                "Items": [
                    { "Label": resources.Email, "AjaxParams": { "distributionType": 0 } },
                    { "Label": resources.EmailReminder, "AjaxParams": { "distributionType": 1 } },
                    { "Label": resources.PopUp, "AjaxParams": { "distributionType": 2 } },
                    { "Label": resources.Twitter, "AjaxParams": { "distributionType": 4 } },
                    { "Label": resources.Facebook, "AjaxParams": { "distributionType": 3 } },
                    { "Label": resources.SMS, "AjaxParams": { "distributionType": 5 } }
                ]
            }
        });

        if ($(".chart").length > 0) {
            a4.callServerMethod(a4.getSurveyAction("DistributionStatusChart", "Distribute"), {}, function (result) {
                a4.initChart($(".chart"), result);
            });
        }
        
    }
}

$(document).ready(function () {
    if (distributionSummary.context.length > 0) {
        distributionSummary.initialize();
    }
});